/* 
 *  PlayDTMFRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class PlayDTMFRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(PlayDTMFRequest.class);
    private final String digits;

    public PlayDTMFRequest(String digits, String interactionID) {
        super(LOG, interactionID);
        this.digits = digits;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().playDTMF(digits);
        LOG.trace(methodName + "-");
        return null;
    }
}
